/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Client.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "strutil.h"       // str2float( ... )


/*******************************************************************
* Function Name: Client
* Description: constructor
********************************************************************/
Client::Client( const string &name )
: Atomic( name )
, changeout(addOutputPort( "changeout" ))
, changein(addInputPort( "changein" ))
, preparationTime( 0, 0, 0, 0 )

{
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

		if( time != "" )
			preparationTime = time ;

}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Client::initFunction()
{
	// [(!) Initialize common variables]
	//this->elapsed = Time::Zero;
	//this->timeLeft = Time::Inf;
    //this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	//this->sigma = Time::Zero; // force an internal transition in t=0;

 	// TODO: add init code here. (setting first state, etc)
 	
 	// set next transition
 	//holdIn( active, this->sigma  ) ;
	this->passivate();
	change = 0;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Client::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	

	this->sigma = nextChange();	
	this->elapsed = msg.time()-lastChange();	
 	this->timeLeft = this->sigma - this->elapsed; 
	
 	if(msg.port() == changein){
 		change = msg.value();
		holdIn( active, preparationTime );
 	}
	
	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Client::internalFunction( const InternalMessage & )
{
	//TODO: implement the internal function here
	change = 0;
	//passivate();
	this->passivate();
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Client::outputFunction( const InternalMessage &msg )
{
	//TODO: implement the output function here
	// remember you can use sendOutput(time, outputPort, value) function.
	if(change == 1)
		sendOutput( msg.time(), changeout, change) ;
	
	return *this;

}

Client::~Client()
{
	//TODO: add destruction code here. Free distribution memory, etc. 
}
